//
// TRACKER SCHEME RESOURCE FILE - Edited by INsane (sturmbot.org) for a smaller and thinner netgraph font. Should work on all HL 1 mods if placed in the resource folder
//             GREEN GUI Colours by INsane 2023
// sections:
//		colors			- all the colors used by the scheme
//		basesettings	- contains settings for app to use to draw controls
//		fonts			- list of all the fonts used by app
//		borders			- description of all the borders
//
// notes:
// 		hit ctrl-alt-shift-R in the app to reload this file (doesn't work)
//      For a test color try Pink... "255 105 180 255"
Scheme
{
	//////////////////////// COLORS ///////////////////////////
	Colors
	{
		// base colors - These are the GUI area not in game all affect the text in GUI screens like Options.
		"BaseText"			"216 222 211 255"   //"216 222 211 255"	// A very light white green - used in text windows, lists like Options - Multiplayer -Player name title (and the name). "245 245 245 255" may be a better choice.
		"BrightBaseText"	"255 255 255 255"	// brightest text, used on Options tabs for the inactive tabs and a lot of the text inside the pages and also most buttons.
		"SelectedText"		"255 255 255 255"	// selected text only like when you edit your player name.
		"DimBaseText"		"160 170 149 255"   //"160 170 149 255"	// dim base text This is like the above, it is the test of the inactive choices in dropdown boxes like the "Options - create server and the unslected map names
		"LabelDimText"		"160 170 149 255"   //"160 170 149 255"	// used for info text like Options = Content "Press this button..."
		"ControlText"		"216 222 211 255"   //"216 222 211 255"	// used in all text controls but only titles of tickbox that are not ticked....disabled.
		"BrightControlText"	"196 181 80 255"   //"196 181 80 255"	// use for selected controls - Like ticked tickbox title Options- Content "Allow custom content" but only when ticked. 
		"DisabledText1"		"117 128 111 255"      //"117 128 111 255"	// disabled text - go to Options Keyboard and the "Clear Key" It affects the text colour right/bottom shadow 
		"DisabledText2"		"40 46 34 255"   //"40 46 34 255"	// disabled text go to Options Keyboard and the "Clear Key" It affects the text colour left/top shadow 
		"DimListText"		"117 134 102 255"	  // No change found (Iight Green) offline friends, unsubscribed games, etc.
		
		//Special color called "test" a pink for locating a item in "Base settings" section
		"test"  "255 105 180 255" // test color

		// background colors - This is the main panels like Options
		"ControlBG"			"76 88 68 255"     // "76 88 68 255" // Default is a green background color of controls // the black here is not a full black
		"ControlDarkBG"		"90 106 80 255"     //"90 106 80 255"	// darker background color; used for background of scrollbars
		"WindowBG"			"62 70 55 255"     //"62 70 55 255"	    // background color of text edit panes (chat, text entries, drop downs etc.)
		"SelectionBG"		"149 136 49 255"  //"149 136 49 255"	// background color of any selected text or menu item
		"SelectionBG2"		"40 46 34 255"     //"40 46 34 255"	Mid Green   // selection background in window w/o focus - as above but pacing a panel ove a panel this BG of a selected item changes color. 
		"ListBG"			"62 70 55 255"     //"62 70 55 255"		// background of server browser, buddy list, etc.

		// titlebar colors - The main title text and BG colours on the panels only like "Options" also handles dim colours of text and Backgrounds
		"TitleText"			"255 255 255 255"  //"255 255 255 255"  // White is standard for main titles only - change only on light panels or white is too contrasting (on Black)
		"TitleDimText"		"136 145 128 255"  // "136 145 128 255" //Def is a LT green when opening another panel, the other one is a dull color - changed to a mid grey 
		"TitleBG"			"76 88 68 0"      //"76 88 68 0"       // Mid Green note its turned off "0" (last number transparency). Its the background of the main panels title back ground. Leave "0" looks best, so does "50" 
		"TitleDimBG"		"76 88 68 0"      //"76 88 68 0"       // Mid Green note its turned off "0"(last number transparency). Its the background of the main panels title back ground. Leave "0" looks best, so does "50" 
		
		// slider tick colors - The text on items like Options - Video "Brightness"
		"SliderTickColor"	"127 140 127 255"  //"127 140 127 255" // The dark to light text and increments
		"SliderTrackColor"	"31 31 31 255"  //"31 31 31 255"    // The track inset (a dark green)

		// border colors - The boarders on the GUI panels and buttons.
		"BorderBright"		"136 145 128 255"   //"136 145 128 255"	// the lit side of a control - that is the left and the top of panels and buttons.
		"BorderDark"		"40 46 34 255"      //"40 46 34 255"	// the dark/unlit side of a control - that is the right and bottom of panels and buttons.
		"BorderSelection"	"0 0 0 255"   //"0 0 0 255"	    // the additional border color for displaying the default/selected button - see this in Options = Keyboard and the "Edit Key" button (disabled) has this border 
	}

	///////////////////// BASE SETTINGS ////////////////////////
	// default settings for all panels
	// controls use these to determine their settings
	// to test put "test" after the setting, e.g. 		"FgColor"			"test"  //"ControlText" 
	BaseSettings
	{
		"FgColor"			"ControlText" //see the menu below too basically these are just following the "Colors" section. Edit the scheme and leave these alone.
		"BgColor"			"ControlBG"
		"LabelBgColor"		"ControlBG"
		"SubPanelBgColor"	"ControlBG"

		"DisabledFgColor1"		"DisabledText1" 
		"DisabledFgColor2"		"DisabledText2"			// set this to the BgColor if you don't want it to draw

		"TitleBarFgColor"			"TitleText"
		"TitleBarDisabledFgColor"	"TitleDimText"
		"TitleBarBgColor"			"TitleBG"
		"TitleBarDisabledBgColor"	"TitleDimBG"

		"TitleBarIcon"				"resource/icon_steam"
		"TitleBarDisabledIcon"		"resource/icon_steam_disabled"

		"TitleButtonFgColor"			"BorderBright"
		"TitleButtonBgColor"			"ControlBG"
		"TitleButtonDisabledFgColor"	"TitleDimText"
		"TitleButtonDisabledBgColor"	"TitleDimBG"

		"TextCursorColor"			"BaseText"			// color of the blinking text cursor in text entries
		"URLTextColor"				"BrightBaseText"	// color that URL's show up in chat window

		Menu
		{
			"FgColor"			"DimBaseText"
			"BgColor"			"ControlBG"
			"ArmedFgColor"		"BrightBaseText"
			"ArmedBgColor"		"SelectionBG"
			"DividerColor"		"BorderDark"

			"TextInset"			"6"
		}

		MenuButton	  // the little arrow on the side of boxes that triggers drop down menus
		{
			"ButtonArrowColor"	"DimBaseText"		// color of arrows
		   	"ButtonBgColor"		"WindowBG"			// bg color of button. same as background color of text edit panes 
			"ArmedArrowColor"	"BrightBaseText"	// color of arrow when mouse is over button
			"ArmedBgColor"		"DimBaseText"		// bg color of button when mouse is over button
		}

		Slider
		{
			"SliderFgColor"		"ControlBG"			// handle with which the slider is grabbed
			"SliderBgColor"		"ControlDarkBG"		// area behind handle
		}

		ScrollBarSlider
		{
			"BgColor"					"ControlBG"		// this isn't really used
			"ScrollBarSliderFgColor"	"ControlBG"		// handle with which the slider is grabbed
			"ScrollBarSliderBgColor"	"ControlDarkBG"	// area behind handle
			"ButtonFgColor"				"DimBaseText"	// color of arrows
		}


		// text edit windows - again these lead back to the "Colors" section
		"WindowFgColor"				"BaseText"		// off-white
		"WindowBgColor"				"WindowBG"		// redundant. can we get rid of WindowBgColor and just use WindowBG?
		"WindowDisabledFgColor"		"DimBaseText"
		"WindowDisabledBgColor"		"ListBG"		// background of chat conversation
		"SelectionFgColor"			"SelectedText"	// fg color of selected text
		"SelectionBgColor"			"SelectionBG"
		"ListSelectionFgColor"		"SelectedText"
		"ListBgColor"				"ListBG"		// background of server browser control, etc
		"BuddyListBgColor"			"ListBG"		// background of buddy list pane
		
		// App-specific stuff
		"ChatBgColor"				"WindowBG"

		// status selection
		"StatusSelectFgColor"		"BrightBaseText"
		"StatusSelectFgColor2"		"BrightControlText"	// this is the color of the friends status

		// checkboxes
		"CheckButtonBorder1"   		"BorderDark"		// the left checkbutton border
		"CheckButtonBorder2"   		"BorderBright"		// the right checkbutton border
		"CheckButtonCheck"			"BrightControlText"	// color of the check itself
		"CheckBgColor"				"ListBG"

		// buttons (default fg/bg colors are used if these are not set)
//		"ButtonArmedFgColor"
//		"ButtonArmedBgColor"
//		"ButtonDepressedFgColor"	"BrightControlText"
//		"ButtonDepressedBgColor"

		// buddy buttons
		BuddyButton
		{
			"FgColor1"				"ControlText"
			"FgColor2"				"DimListText"
			"ArmedFgColor1"			"BrightBaseText"
			"ArmedFgColor2"			"BrightBaseText"
			"ArmedBgColor"			"SelectionBG"
		}

		Chat
		{
			"TextColor"				"BrightControlText"
			"SelfTextColor"			"BaseText"
			"SeperatorTextColor"	"DimBaseText"
		}

		InGameDesktop // the main GUI text and other adjustments
		{
			"MenuColor"					"255 255 255 255"   //  STD "238 174 0 255" // the inactive New game, Find servers ...ect titles "255 255 255 255" may be better
			"ArmedMenuColor"			"96 96 96 255"      //  STD "255 186 0 255" // the active New game, Find servers ...ect titles "224 224 224 255"
			"BlurMenuColor"				"100 100 100 255"   //NEW HL25 "255 178 67 255" //( Yellow-Orange) the active "mouse over" effect of New game, Find servers ...ect titles
			"DepressedMenuColor"        "16 16 16 255"      //  STD changes when you press a main menu item
			"MenuHintColor"				"104 104 104 255"   //NEW HL25 //"104 104 104 255" Not sure what this is
			"WidescreenBarColor" 		"0 0 0 0"           //  STD the "Day of Defeat" title below "Quit" the background stip along the entire GUI bottom screen
			"MenuItemVisibilityRate"	"0.02"              //  STD time it takes for one menu item to appear
			"MenuItemHeight"			"48"                //  STD this is proportional to resolution
			"GameMenuInset"				"110"               //  STD
		}

		"SectionTextColor"		"BrightControlText"	// text color for IN-GAME, ONLINE, OFFLINE sections of buddy list
		"SectionDividerColor"	"BorderDark"		// color of line that runs under section name in buddy list
		
		"ProportionalBaseWidth" "640"		// if the display resolution is above this, 
		"ProportionalBaseHeight" "480"		//  ui elements will be scaled.
		"ProportionalBaseWidthHD" "1280"	//	"1280"
		"ProportionalBaseHeightHD" "720"	//	"720"
	}

	//
	//////////////////////// FONTS /////////////////////////////
	//
	// describes all the fonts
	Fonts
	{
		// fonts are used in order that they are listed
		// fonts listed later in the order will only be used if they fulfill a range not already filled
		// if a font fails to load then the subsequent fonts will replace
		//
		//   
		"Default"  // This affects almost every font in the GUI panels. No effect in HUD.
		{
			"1"
			{
				"name"		"Tahoma"  // "Times New Roman" (def)
				"tall"		"12"       //"12" (def)			
				"weight"	"400"      //"400" (def)    
				"yres"	"480 599"
				"antialias"	"1"
			}
			"2"
			{
				"name"		"Tahoma" // "Times New Roman" (def)
				"tall"		"13"      //"13" (def)
				"weight"	"400"      //"400" (def) 
				"yres"	"600 767"
				"antialias"	"1"				
			}
			"3"
			{
				"name"		"Tahoma"  // "Times New Roman" (def) 
				"tall"		"14"       //"14" (def)
				"weight"	"400"      //"400" (def) 
				"yres"	"768 1023"
				"antialias"	"1"
			}
			"4"
			{
				"name"		"Tahoma" // "Times New Roman" (def)
				"tall"		"20"     //"20" (def)
				"weight"	"400"      //"400" (def) 
				"yres"	"1024 1199"
				"antialias"	"1"
			}
			"5"
			{
				"name"		"Tahoma" // "Times New Roman" (def)
				"tall"		"24"      //"24" (def)
				"weight"	"400"      //"400" (def) 
				"yres"	"1200 6000"
				"antialias"	"1"
			}
		}
		"DefaultBold"  // No effect seen in GUI or HUD
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"  (def)
				"weight"	"500"
			}
		}
		"DefaultUnderline"  // No underline stuff in dod anyway !!!! No effect on GUI or HUD
		{
			"1"
			{
				"name"		"Tahoma"  //"Tahoma" (def)  
				"tall"		"16"      // "16" (def)
				"weight"	"0"
				"underline" "1"
			}
		}
		"DefaultSmall"    // Affects the GUI servers panel (only) fonts in the "players - Servers" Title and the server list. No HUD effects.
		{
			"1"
			{
				"name"		"Tahoma"  //"Tahoma" (def)
				"tall"		"13"      // "13" (def)
				"weight"	"0"
			}
		}
		"DefaultSmallBold"  // No effect seen in GUI or HUD
		{
			"1"
			{
				"name"		"Tahoma"  //"Tahoma" (def)
				"tall"		"12"      // "12" (def)
				"weight"	"600"
			}
		}
		"DefaultVerySmall"  // No effect seen in GUI or HUD
		{
			"1"
			{
				"name"		"Tahoma"   //"Tahoma"  //"Tahoma" (def)
				"tall"		"12"      // "12" (def)
				"weight"	"0"
			}
		}
		"MenuLarge"      // The font for the main menu - New game - Find servers - Options - Quit - it does not scale very well
		{
			"1"  
			{
				"name"		"Trebuchet MS"   //"Trebuchet MS" (def)
				"tall"		"24"             //"28" (def)
				"weight"	"1000"
				"dropshadow" "1"
				"antialias"	"1"
				"blur" "0"
			}
		}
		"MenuBlurLarge"  // The BLUR font for the GUI main menu - New game - Find servers - Options - Quit (no HUD effect)
		{
			"1"
			{
				"name"		"Trebuchet MS"  //"Trebuchet MS" (def)  - make sure you match the above!
				"tall"		"24"            //"28" (def) - make sure you match the above!
				"weight"	"800"    //"800" (def)
				"dropshadow" "0"
				"antialias"	"0"
				"blur" "1"         // "5" (def) 0 = OFF but you see the font dull. "1" = very slight (Nice). "2" has bars. "3" looks same as 5. (5 is Max)
				"additive" "1"
			}
		}
		"MenuHintLarge"    // No Effect seen in GUI or HUD
		{
			"1"
			{
				"name"		"Trebuchet MS"  //"Trebuchet MS" (def)
				"tall"		"24"       // "24" (def)
				"weight"	"200"
				"dropshadow" "0"
				"antialias"	"1"
				"blur" "0"
			}
		}
		"MenuHintSmall"    // No Effect seen in GUI or HUD
		{
			"1"
			{
				"name"		"Trebuchet MS"     //"Trebuchet MS" (def)
				"tall"		"20"              // "20" (def)
				"weight"	"200"
				"dropshadow" "0"
				"antialias"	"1"
				"blur" "0"
			}
		}
		"UiHeadline"      // No Effect seen in GUI or HUD
		{
			"1"
			{
				"name"		"Verdana"   //"Verdana" (def)
				"tall"		"16"        //"16" (def)
				"weight"	"1000"
				"antialias" "0"
			}
		}

		// this is the symbol font  -  No Effect seen in GUI or HUD
		"Marlett"
		{
			"1"
			{
				"name"		"Marlett"   //"Marlett" (def)
				"tall"		"14"        // "14" (def)
				"weight"	"0"
				"symbol"	"1"
			}
		}
		
		
		"EngineFont"	// IMPORTANT: Effects the dod HUD  - Netgraph, Kills and Deaths, Target ID and server messages 
						// You can change the text size and weight but its got to be right on for all resolutions below - be careful! 
						// The bold (weight) setting for font has a better effect. "550" turns off bold and "551" and above turns it on. Not like the "0" - "900" settings !
						// In some fonts the kills and deaths look ugly - Bold looks best in K and D! Verdana Bold is good but make sure size is reduced as the netgraph goes off screen.
						// Netgraph, Kills and Deaths and "Target ID" are linked its a matter of balancing out those three.
						//
						//		"yres" (Y is height - X is width) This defines two values based on the screen width. If the current game screen resolution falls within this range then the font will be used. 
						//      The format - Its back to front. Height is the first value, then the Width (longer). 
						// 		The HEIGHT is the one to watch for adjustments, if the second value is your screen HEIGHT OR UNDER, then adjust that. 
						//
						//	"1"	- "yres"	"480 599"   - Screen Height up to and including height 599. e.g.: 640 X 480 fits but 800 X 600 does not, go to "2" next...
						//	"2" - "yres" 	"600 767"   - up to and including heights (like a 800 W X 600 H) but not a 1366 W X 768 H, go to "3"...      
						//	"3"	- "yres"	"768 1023"  - up to and including 1023 high like a 1366 x 768 But not 1024 X 768.   and so on....
						//			
		{
			"1"  // Typical screen  - Standard Definition (SD) 480p	4:3	640 x 480 OR - any height below 599 
			{
				"name"		"System"		//"Verdana" (def) - small font "Trebuchet MS" is good too
				"tall"		"13"           //"13" (def) Adjust down if using larger fonts. Between 10-15 depending on font.
				"weight"	"550"          //(def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"yres"	    "480 599"      // Screen Height Range, Between 480 X 599 only
				"dropshadow"	"1"
			}
			"2"  // Typical screen - High Definition (HD) 720p 16:9	1280 x 720 - 4:3 800 X 600 OR - any height below 767 
			{
				"name"		"System"		//"Verdana" (def) - small fonts "Calibri" and "Trebuchet MS" are good with "Calibri" is clearer, and fixs the netgraph off the right screen issue.
				"tall"	    "13"           // "15" (def). Adjust down if using larger fonts. Between 11- 18 depending on font.  
				"weight"	"550"          // "600" (def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"yres"	    "600 767"      // the screen res, in this case 600 wide X 800 high (767) - 800 high screens
				"dropshadow"	"1"				
			}
			"3" // Typical screen - High Definition (HD) 720p 16:9 1366 X 768 (common on old laptops) OR - any height below 1023
			{
				"name"		"System"		//"Verdana" (def) - small fonts "Calibri" and "Trebuchet MS" are good.
				"tall"		"16"           // "16" (def) Adjust down if using larger fonts. Between 12-18 depending on font.
				"weight"	"550"          // "600" (def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"yres"	    "768 1023"    // the screen res, in this case 768 wide X 1024 (1023) - 1024 high screens
				"dropshadow"	"1"			
			}
			"4" // Very Common - Most 16:9 Default screens - 1920 X 1080 OR - any height below 1299 
			{
				"name"		"System"		//"LiberationSans-Bold"	//"Arial"	//"Trebuchet MS"	//"Verdana"      //"Verdana" (def) - small fonts "Tahoma" with "20"
				"tall"		"21"           // "21" (def for Verdana) Adjust down if using larger fonts. Between 15-23 depending on font.
				"weight"	"550"          // "600" (def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"yres"	    "1024 1299"   // up to and including 1299 high like 1600 X 900, 1920 X 1080, 1920 X 1200, 2560 X 1080
				"dropshadow"	"1"
			}
			"5" //Common -  Most 21:9 and 32:9 Default screens will use this - 3440 X 1440 up to 5120 X 1440 - 16:9 3840 X 2160- OR - any height below 1699
			{
				"name"		"System"		//"LiberationSans-Bold"	//"Verdana" (def) - small fonts "Calibri" and "Trebuchet MS" are good. "Helvetica"
				"tall"		"28"           //"28" (def)  Adjust down like the above if using larger fonts. Small font = 18-19 Normal - 19-24
				"weight"	"550"          // "600" (def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"yres"	    "1300 1699"    // up to and including 1699 high like 2160 X 1600 and 3440 X 1440 (MOST ULTRA WIDE) - but not 3840 X 2160 (4K) 
				"dropshadow"	"1"
			}
			"6" // Big screen heights like 3200 X 1800 (QHD+)  - OR - any height below 1899
			{
				"name"		"System"		//"LiberationSans-Bold"	//"Verdana" (def) - small fonts "Calibri" and "Trebuchet MS" are good. "Helvetica"
				"tall"		"35"           //"35" (def) 
				"weight"	"550"          // "600" (def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"yres"	    "1700 1899"   // up to and including 1899 high (Under 4K and 5K) 
				"dropshadow"	"1"
			}
			"7" // Big screen heights like 16:9 3840 X 2160 (4K UHD)  - OR - any height below 2499
			{
				"name"		"System"		//"LiberationSans-Bold"	//"Verdana" (def) - small fonts "Calibri" and "Trebuchet MS" are good. "Helvetica"
				"tall"		"42"          //"42" (def) 
				"weight"	"550"         // "600" (def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"yres"	    "1900 2499"   // up to and including 2499 high Like 3840 X 2160(4K) also 5120 X 2160 (5K) But not 8K or 10K
				"dropshadow"	"1"
			}
			"8" // Big screen heights like 16:9 5120 X 2880 (5K)  - OR - any height below 2999
			{
				"name"		"System"		//"LiberationSans-Bold"	//"Verdana" (def) - small fonts "Calibri" and "Trebuchet MS" are good. "Helvetica"
				"tall"		"56"           // "56" (def)
				"weight"	"550"          // "600" (def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"yres"	    "2500 2999"   // up to and including 2999 high (under 8K and 10K)
				"dropshadow"	"1"
			}
			"9" // Big screen heights like 16:9 7680 X 4320 (8K UHD)  - OR - any height below 10000
			{
				"name"		"System"		//"LiberationSans-Bold"	//"Verdana" (def) - small fonts "Calibri" and "Trebuchet MS" are good. "Helvetica"
				"tall"		"70"           // "70" (def)
				"weight"	"550"          // "600" (def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"yres"	    "3000 10000"   // up to and including 10000 Like 7680 X 4320(8K) and 102040 X 4320 (10K)	
				"dropshadow"	"1"
			}
		}	
		
		"CreditsFont" // This is the Ammo numbers in the HUD, Server messages, the text below the objective icons- a problem on Widescreens going off the screen and now scaled - INsane.
		{
			"1"  // Typical screen  - Standard Definition (SD) 480p	4:3	640 x 480 OR - any height below 599 
			{
				"name"		"Trebuchet MS" //"Trebuchet MS" (def) - small font "Trebuchet MS" is good too
				"tall"		"14"           //"12" (def) Adjust down if using larger fonts. Between 10-15 depending on font.
				"weight"	"600" 				// "700"(def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"antialias"	"0"
				"yres"	    "480 599"      // Screen Height Range, Between 480 X 599 only
				"dropshadow"	"1"					
			}
			"2"  // Typical screen - High Definition (HD) 720p 16:9	1280 x 720 - 4:3 800 X 600 OR - any height below 767 
			{
				"name"		"Trebuchet MS" //"Trebuchet MS" (def) - small fonts "Calibri" and "Trebuchet MS" are good with "Calibri" is clearer, and fixs the netgraph off the right screen issue.
				"tall"	    "15"           // "13" (def). Adjust down if using larger fonts. Between 11- 18 depending on font.
				"weight"	"600"          // "700" (def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"antialias"	"0"
				"yres"	    "600 767"      // the screen res, in this case 600 wide X 800 high (767) - 800 high screens	
				"dropshadow"	"1"					
			}
			"3" // Typical screen - High Definition (HD) 720p 16:9 1366 X 768 (common on old laptops) OR - any height below 1023
			{
				"name"		"Trebuchet MS" //"Trebuchet MS" (def) - small fonts "Calibri" and "Trebuchet MS" are good.
				"tall"		"16"           // "14" (def) . Between 12-18 depending on font.
				"weight"	"700"          // "700" (def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"antialias"	"0"
				"yres"	    "768 1023"     // the screen res, in this case 768 wide X 1024 (1023) - 1024 high screens		
				"dropshadow"	"1"				
			}
			"4" // Very Common - Most 16:9 Default screens - 1920 X 1080 OR - any height below 1299 
			{
				"name"		"Trebuchet MS"  //"Trebuchet MS" (def) - small fonts "Tahoma" with "20" "Arial Narrow"
				"tall"		"22"            // "20" (def for Verdana) Adjust down if using larger fonts. Between 15-23 depending on font.
				"weight"	"700"           // "700" (def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"antialias"	"0"
				"yres"	    "1024 1299"     // up to and including 1299 high like 1600 X 900, 1920 X 1080, 1920 X 1200, 2560 X 1080  
				"dropshadow"	"1"					
			}
			"5" //Common -  Some 21:9 and 32:9 Default screens will use this - 3440 X 1440 up to 5120 X 1440 - 16:9 3840 X 2160- OR - any height below 1699
			{
				"name"		"Trebuchet MS" //"Trebuchet MS" (def)
				"tall"		"28"           //"26" (def)  Adjust down like the above if using larger fonts. Small font = 18-19 Normal - 19-24
				"weight"	"700"          // "700" (def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"antialias"	"0"
				"yres"	    "1300 1699"    // up to and including 1699 high like 2160 X 1600 and 3440 X 1440 (MOST ULTRA WIDE) - but not 3840 X 2160 (4K) 
				"dropshadow"	"1"					
			}
			"6" // Big screen heights like 3200 X 1800 (QHD+)  - OR - any height below 1899
			{
				"name"		"Trebuchet MS" //"Trebuchet MS" (def)
				"tall"		"32"           //"28" (def)
				"weight"	"700"          // "700" (def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"antialias"	"0"
				"yres"	    "1700 1899"    // up to and including 1899 high (Under 4K and 5K) 
				"dropshadow"	"1"					
			}
			"7" // Big screen heights like 16:9 3840 X 2160 (4K UHD)  - OR - any height below 2499
			{
				"name"     "Trebuchet MS" //"Trebuchet MS" (def)
				"tall"		"60"          //"70" (def)
				"weight"	"700"         // "700" (def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"antialias"	"0"
				"yres"	    "1900 2499"   // up to and including 2499 high Like 3840 X 2160(4K) also 5120 X 2160 (5K) But not 8K or 10K
				"dropshadow"	"1"					
			}
			"8" // Big screen heights like 16:9 5120 X 2880 (5K)  - OR - any height below 2999
			{
				"name"		"Trebuchet MS" //"Trebuchet MS" (def)
				"tall"		"80"           // "90" (def)
				"weight"	"700"          // "700" (def) For adjusting bold, 600 is bold, 550 or less will make the font thin.
				"antialias"	"0"
				"yres"	    "2500 2999"    // up to and including 2999 high (under 8K and 10K)
				"dropshadow"	"1"					
			}
		}

		"Legacy_CreditsFont" // Added to accomodate 3rd party server plugins, etc. This version should not scale.
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"20"  //"20"
				"weight"	"700"
				"antialias"	"1"
				"yres"	"1 10000"
			}
		}

		"GameConsole_Mono"
		{
			"1"
			{
				"name"		"Courier"
				"tall"		"14"     //"14"
				"weight"	"500"
			}
		}
    }

	//
	//////////////////// BORDERS //////////////////////////////
	//
	// describes all the border types
	Borders
	{
		// references to other borders
		BaseBorder		"InsetBorder"
		ComboBoxBorder	"InsetBorder"
		BrowserBorder	"InsetBorder"
		ButtonBorder	"RaisedBorder"
		FrameBorder		"RaisedBorder"
		TabBorder		"RaisedBorder"
		MenuBorder		"RaisedBorder"
		
		// standard borders
		InsetBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}

		RaisedBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		// special border types
		TitleButtonBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"4"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		TitleButtonDisabledBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BgColor"
					"offset" "1 0"
				}
			}
			Top
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 0"
				}
			}
		}

		TitleButtonDepressedBorder
		{
			"inset" "1 1 1 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}

		ScrollBarButtonBorder
		{
			"inset" "1 0 0 0"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		ScrollBarButtonDepressedBorder
		{
			"inset" "2 2 0 0"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}
		
		TabActiveBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "6 2"
				}
			}
		}


		ToolTipBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}
		}

		// this is the border used for default buttons (the button that gets pressed when you hit enter)
		ButtonKeyFocusBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderBright"
					"offset" "0 1"
				}
			}
			Top
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}
			Right
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderDark"
					"offset" "1 0"
				}
			}
			Bottom
			{
				"1"
				{
					"color" "BorderSelection"
					"offset" "0 0"
				}
				"2"
				{
					"color" "BorderDark"
					"offset" "1 1"
				}
			}
		}

		ButtonDepressedBorder
		{
			"inset" "2 1 1 1"
			Left
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "BorderDark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BorderBright"
					"offset" "0 0"
				}
			}
		}
	}
	
	//////////////////////// CUSTOM FONT FILES /////////////////////////////
	//
	// specifies all the custom (non-system) font files that need to be loaded to service the above described fonts
	CustomFontFiles
	{
		"4"		"resource/linux_fonts/DejaVuSans.ttf"
		"5"		"resource/linux_fonts/DejaVuSans-Bold.ttf"
		"6"		"resource/linux_fonts/DejaVuSans-BoldOblique.ttf"
		"7"		"resource/linux_fonts/DejaVuSans-Oblique.ttf"
		"8"		"resource/linux_fonts/LiberationSans-Regular.ttf"
		"9"		"resource/linux_fonts/LiberationSans-Bold.ttf"
		"10"		"resource/linux_fonts/LiberationMono-Regular.ttf"
		"11"		"resource/linux_fonts/FiraSans-Regular.ttf"
		"12"		"resource/linux_fonts/FiraSans-Medium.ttf"
	}
}
